export default class Text{
    
    static fonts = [{chars:"0123456789+-", width:"555555555544", height:5},
                    {chars:"0123456789:", width:"88888888884", height:12}];

    static img(txt, idFont = 1){
        txt = txt.toString();
        if(!APP.images["txt_"+idFont+"_"+txt]){ this.createImg(txt, idFont); }
        return APP.images["txt_"+idFont+"_"+txt];
    }

    static createImg(txt, idFont){
        const img = APP.images['text'];
        const buffer = document.createElement('canvas');
        if(!img){ buffer.width = 0; buffer.height = 0; return buffer; }
        //Creation de la nouvelle image
        const font = this.fonts[idFont];
        buffer.width = this.getTxtWidth(txt, idFont);
        buffer.height = font.height;
        const ctx = buffer.getContext('2d');
        let txtWidth = 0;
        for(let index in txt){
            let charIndex = font.chars.indexOf(txt[index]);
            if(charIndex<0){ continue; }
            let imgX = 0;
            let imgY = 0;
            let width = parseInt(font.width[charIndex]);
            for(let i=0; i<charIndex; i++){ imgX += parseInt(font.width[i]); }
            for(let i=0; i<idFont; i++){ imgY += this.fonts[i].height; }
            ctx.drawImage(img, imgX, imgY, width, font.height, txtWidth, 0, width, font.height);
            txtWidth += width-1;
        }
        //On sauvegarde l'image avant de la renvoyer
        APP.images["txt_"+idFont+"_"+txt] = buffer;
    }

    static getTxtWidth(txt, idFont) {
        let txtWidth = 0;
        const font = this.fonts[idFont];
        for(let index in txt){
            let charIndex = font.chars.indexOf(txt[index]);
            if(charIndex<0){ continue; }
            let width = parseInt(font.width[charIndex]);
            txtWidth += width-1;
        }
        txtWidth++;
        return txtWidth;
    }

}